/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.dialog;

import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.indexer.IIndexChangeListener;
import com.aptana.editor.php.internal.search.IElementNode;
import com.aptana.editor.php.internal.search.ITypeNode;
import com.aptana.editor.php.internal.search.PHPSearchEngine;
import com.aptana.editor.php.internal.ui.dialog.CustomFilteredItemsSelectionDialog;
import com.aptana.editor.php.internal.ui.editor.outline.PHPOutlineLabelProvider;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SearchPattern;
import org2.eclipse.php.core.compiler.PHPFlags;

public class TypeSelectionDialog
extends CustomFilteredItemsSelectionDialog {
    private IProject project;
    private boolean allowInterfaces = true;
    private boolean allowClasses = true;
    private IIndexChangeListener listener = new IIndexChangeListener(){

        @Override
        public void stateChanged(boolean done, String message) {
            if (done) {
                TypeSelectionDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TypeSelectionDialog.this.refreshContent();
                    }
                });
            }
        }

        @Override
        public void changeProcessed() {
        }
    };

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public boolean isAllowInterfaces() {
        return this.allowInterfaces;
    }

    public void setAllowInterfaces(boolean allowInterfaces) {
        this.allowInterfaces = allowInterfaces;
    }

    public boolean isAllowClasses() {
        return this.allowClasses;
    }

    public void setAllowClasses(boolean allowClasses) {
        this.allowClasses = allowClasses;
    }

    public TypeSelectionDialog(Shell shell, boolean multi) {
        super(shell, multi);
        this.setDetailsLabelProvider((ILabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof IElementNode) {
                    return PHPOutlineLabelProvider.BLOCK_ICON;
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                if (element instanceof IElementNode) {
                    IElementNode node = (IElementNode)element;
                    return node.getPath();
                }
                return super.getText(element);
            }
        });
        this.setListLabelProvider((ILabelProvider)new TypeLabelProvider());
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    public void create() {
        super.create();
        PHPSearchEngine.getInstance().addListener(this.listener);
        this.setHelpAvailable(false);
    }

    public boolean close() {
        PHPSearchEngine.getInstance().removeListener(this.listener);
        return super.close();
    }

    protected CustomFilteredItemsSelectionDialog.ItemsFilter createFilter() {
        Text txt = (Text)this.getPatternControl();
        final String text = txt.getText();
        SearchPattern searchPattern = new SearchPattern();
        searchPattern.setPattern(text);
        CustomFilteredItemsSelectionDialog.ItemsFilter itemsFilter = new CustomFilteredItemsSelectionDialog.ItemsFilter(this, searchPattern){

            public boolean isConsistentItem(Object item) {
                return true;
            }

            public boolean matchItem(Object item) {
                if (item instanceof ITypeNode) {
                    ITypeNode node = (ITypeNode)item;
                    if (!TypeSelectionDialog.this.isAllowClasses() && !PHPFlags.isInterface((int)node.getModifiers())) {
                        return false;
                    }
                    if (!TypeSelectionDialog.this.isAllowInterfaces() && PHPFlags.isInterface((int)node.getModifiers())) {
                        return false;
                    }
                    if (TypeSelectionDialog.this.project != null && !node.isOnBuildPath(TypeSelectionDialog.this.project)) {
                        return false;
                    }
                    if (text.length() == 0) {
                        return true;
                    }
                }
                return super.matches(TypeSelectionDialog.this.getElementName(item));
            }
        };
        return itemsFilter;
    }

    protected void fillContentProvider(CustomFilteredItemsSelectionDialog.AbstractContentProvider contentProvider, CustomFilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        Collection<ITypeNode> allKnownTypes = PHPSearchEngine.getInstance().getAllKnownTypes();
        for (ITypeNode o : allKnownTypes) {
            contentProvider.add((Object)o, itemsFilter);
        }
    }

    protected IDialogSettings getDialogSettings() {
        return PHPEditorPlugin.getDefault().getDialogSettings();
    }

    public String getElementName(Object item) {
        IElementNode node = (IElementNode)item;
        return node.getName();
    }

    protected Comparator getItemsComparator() {
        return new Comparator<IElementNode>(){

            @Override
            public int compare(IElementNode o1, IElementNode o2) {
                int compareTo = o1.getName().compareTo(o2.getName());
                if (compareTo == 0) {
                    return o1.getPath().compareTo(o2.getPath());
                }
                return compareTo;
            }
        };
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    public static final class TypeLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            if (element instanceof ITypeNode) {
                ITypeNode node = (ITypeNode)element;
                if (node.getKind() == 4) {
                    return PHPOutlineLabelProvider.TRAIT_ICON;
                }
                int modifiers = node.getModifiers();
                if (PHPFlags.isInterface((int)modifiers)) {
                    return PHPOutlineLabelProvider.INTERFACE_ICON;
                }
                return PHPOutlineLabelProvider.CLASS_ICON;
            }
            if (element instanceof IElementNode) {
                IElementNode nm = (IElementNode)element;
                if (nm.getKind() == 2) {
                    return PHPOutlineLabelProvider.FUNCTION_ICON;
                }
                if (nm.getKind() == 3) {
                    return PHPOutlineLabelProvider.LOCALVARIABLE_ICON;
                }
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof IElementNode) {
                IElementNode node = (IElementNode)element;
                return String.valueOf(node.getName()) + " - " + node.getPath();
            }
            return super.getText(element);
        }
    }
}

